DROP PROCEDURE [hips].[EpisodeUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew Jacks
-- Create date: 23 October 2012
-- Description:   Updates a record in the Episodes Table
-- Modified:    22/11/2012 sbiber added Ward,Room,Bed
-- Modified:    18/12/2012 sbiber changed UploadConsent to ConsentWithdrawn
-- Modified:    31/07/2013 sbiber clear the discharge date when patient is admitted as inpatient after being discharged from emergency
-- =============================================
CREATE PROCEDURE [hips].[EpisodeUpdate] 
(
	@EpisodeId INT,
	@PatientId INT,
	@SourceSystemEpisodeId VARCHAR(100),
	@AdmissionDate DATETIME,
	@AdmissionReason VARCHAR(1000) = NULL,
	@DischargeDate DATETIME = NULL,
	@ResponsibleProviderId INT,
	@EpisodeTypeId INT,
	@EpisodeLifecycleId INT = NULL,
	@ConsentWithdrawn BIT,
	@Ward VARCHAR(40) = NULL,
	@Room VARCHAR(40) = NULL,
	@Bed VARCHAR(40) = NULL,
	@UserModified varchar(256),
	@DateModified datetime
)
AS
BEGIN
    SET NOCOUNT ON
 DECLARE @intErrorCode int

    SET @intErrorCode = 0

    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[Episode]
				WHERE [EpisodeId] = @EpisodeId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN
		IF @AdmissionDate = @DischargeDate AND @EpisodeLifecycleId = 11
		BEGIN
			SET @DischargeDate = NULL
		END

        UPDATE [hips].[Episode]
           SET [PatientId] = @PatientId
            ,[SourceSystemEpisodeId] = @SourceSystemEpisodeId
            ,[AdmissionDate] = @AdmissionDate
			,[AdmissionReason] = @AdmissionReason
			,[DischargeDate] = @DischargeDate
			,[ResponsibleProviderId] = @ResponsibleProviderId
			,[EpisodeTypeId] = @EpisodeTypeId
			,[EpisodeLifecycleId] = @EpisodeLifecycleId
			,[ConsentWithdrawn] = @ConsentWithdrawn
			,[Ward] = @Ward
			,[Room] = @Room
			,[Bed] = @Bed
            ,[DateModified] = GetDate()
            ,[UserModified] = @UserModified
         WHERE [EpisodeId] = @EpisodeId

        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
		SELECT e.EpisodeId
			,e.PatientId
			,e.SourceSystemEpisodeId
			,e.AdmissionDate
			,e.AdmissionReason
			,e.DischargeDate
			,e.ResponsibleProviderId
			,e.EpisodeTypeId
			,et.Description AS EpisodeType
			,e.EpisodeLifecycleId
			,ec.Description AS EpisodeLifecycle
			,e.ConsentWithdrawn
			,e.Ward
			,e.Room
			,e.Bed
			,e.DateCreated
			,e.UserCreated
			,e.DateModified
			,e.UserModified
		FROM hips.Episode e
		LEFT JOIN [hips].[EpisodeType] AS et on et.EpisodeTypeId = e.EpisodeTypeId
		LEFT JOIN [hips].[EpisodeLifecycle] AS ec on ec.EpisodeLifecycleId = e.EpisodeLifecycleId
		WHERE @EpisodeId = e.EpisodeId
    END

    RETURN(@intErrorCode)
END
GO

